### 详细描述

Cobalt/POSIX 接口是在 Cobalt 核心上实现的单一 Unix 规范的子集。

这个子集中的例程被实现为由链接器定义的包装函数（--wrap 选项，参见 man ld(1)）。构建实时应用程序的完整文档可以在 [构建实时应用程序](../buildrt) 找到。

当启用符号包装时：

对 Cobalt 提供（实时）实现的 POSIX 服务的调用将被重定向到实现包装器的库，默认是 libcobalt。libcobalt 覆盖的包装符号列表。
无论是否启用符号包装：

可以通过使用 __RT() 宏将函数调用括起来显式调用 POSIX 例程的包装函数。由于包装符号是弱符号，它可能会被第三方库覆盖，通常是为了实现其自己的 POSIX 调用版本，替代或在 libcobalt 之上。例如，__RT(sem_init(&sem, 0, 0)) 将初始化一个实时信号量，通常来自 libcobalt，除非第三方库提供了更强的 sem_init() 包装器。
可以通过使用 __COBALT() 宏将函数调用括起来显式调用 POSIX 例程的 libcobalt 实现。例如，__COBALT(sem_init(&sem, 0, 0)) 将始终初始化一个 Cobalt 信号量（强符号）。
可以通过使用 __STD() 宏将函数调用括起来显式调用 POSIX 例程的常规 libc 实现。这种形式基本上防止了符号包装的发生。例如，__STD(sem_init(&sem, 0, 0)) 将始终初始化一个常规的 libc 信号量。这严格等同于调用 ld(1) 文档中记录的此类例程的 __real_ 形式。
如上所述显式限定 POSIX 调用可能在大型 POSIX 代码库中选择性调用实时服务时非常有用，对于这种情况，全局启用符号包装是不切实际的。这也可能有助于实现实时服务库，对于这些库来说，依赖链接器的符号包装机制是不合适的。

话虽如此，遵循 POSIX 标准而不使用宏技巧来开发应用程序也可能是一个显著的优点。视情况而定。